/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.mixin;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.misc.ExtendedStatusEffectInstance;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements AccessoriesAPIAccess {
    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"takeShieldHit"}, at={@At(value="HEAD")})
    public void onShieldHit(class_1309 attacker, CallbackInfo ci) {
        class_1309 user = (class_1309)this;
        if (!user.method_6030().method_31573(Things.ENCHANTABLE_WITH_RETRIBUTION)) {
            return;
        }
        if (user.method_6030().method_58657().method_57536((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_41265).method_40264(Things.RETRIBUTION).get()) < 1) {
            return;
        }
        user.method_6092(new class_1293(class_1294.field_5910, 40, 0));
    }

    @Inject(method={"blockedByShield"}, at={@At(value="RETURN")})
    public void onShieldBlock(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        class_1309 user = (class_1309)this;
        if (!user.method_6030().method_31573(Things.ENCHANTABLE_WITH_RETRIBUTION)) {
            return;
        }
        if (user.method_6030().method_58657().method_57536((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_41265).method_40264(Things.RETRIBUTION).get()) < 1) {
            return;
        }
        user.method_6092(new class_1293(class_1294.field_5910, 40, 0));
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/registry/entry/RegistryEntry;)Z", ordinal=1), ordinal=1)
    public float waxGlandWater(float j) {
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability == null || !capability.isEquipped(ThingsItems.ENCHANTED_WAX_GLAND)) {
            return j;
        }
        return j * Things.CONFIG.waxGlandMultiplier();
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V"))
    public float waxGlandLava(float speed) {
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability != null && capability.isEquipped(ThingsItems.ENCHANTED_WAX_GLAND) && capability.isEquipped(ThingsItems.HADES_CRYSTAL)) {
            float depthStrider = (float)(this.method_45325((class_6880<class_1320>)class_5134.field_51578) * 3.0);
            return 0.0175f * Things.CONFIG.waxGlandMultiplier() + 0.1f * depthStrider;
        }
        return speed;
    }

    @ModifyVariable(method={"handleFallDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/LivingEntity;computeFallDamage(FF)I"))
    private int decreaseFallDamage(int originalFallDamage) {
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability != null && capability.isEquipped(ThingsItems.SHOCK_ABSORBER)) {
            return originalFallDamage - (int)Math.min(16.0f, (float)originalFallDamage * 0.2f);
        }
        return originalFallDamage;
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private float decreaseKineticDamage(class_1282 source, float damage) {
        if (source.method_48792() != this.method_37908().method_48963().method_48828().method_48792()) {
            return damage;
        }
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability != null && capability.isEquipped(ThingsItems.SHOCK_ABSORBER)) {
            return damage / 4.0f;
        }
        return damage;
    }

    @ModifyArg(method={"readCustomDataFromNbt"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), index=1)
    private Object attachPlayerToEffect(Object effect) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
        return effect;
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="HEAD")})
    private void attachPlayerToEffect(class_1293 effect, class_1297 source, CallbackInfo ci) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="HEAD")})
    private void attachPlayerToEffect(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
    }
}

